#include "POP3.h"

// TO-DO: Replace the sscanf() function with a flexible parser.  

static bool sPop3Trace;
#define LLOG(x) do { if(sPop3Trace) RLOG(x); } while(0)

void Pop3::Trace(bool b)
{
	sPop3Trace = b;
}

String Pop3::GetTimeStamp()
{
	int begin = data.Find('<');
	if(begin >= 0) {
		int end = data.Find('>', begin);
		if(end > begin) {
			end++;
			return data.Mid(begin, end - begin);
		}
	}
	return Null;
}

bool Pop3::GetListItems(ValueMap& list, dword type1, dword type2)
{
	StringStream s(data);
	for(;;) {
		String line = s.GetLine();
		if(s.IsError())
			return false;
		if(s.IsEof())
			break;
		Buffer<char> tag1(32), tag2(32);
		sscanf(line, "%s %s", &tag1[0], &tag2[0]);
		Value v1, v2;
		if(type1 == INT_V)
			v1 = StrInt(&tag1[0]);
		else
			v1 = String(&tag1[0]);
		if(type2 == INT_V)
			v2 = StrInt(&tag2[0]);
		else
			v2 = String(&tag2[0]);
		list.Add(v1, v2);
	}
	return true;	
}

int Pop3::GetMessageCount()
{
	if(!PutGet("STAT\r\n"))
		return -1;
	Buffer<char> ok(4), cnt(16), tsz(16);
	sscanf(data, "%s %s %s", &ok[0], &cnt[0], &tsz[0]);
	return StrInt(cnt);
}

String Pop3::GetMessage(int index)
{
	if(!PutGet(Format("RETR %d\r\n", index), true))
		return Null;
	return data;	
}

String Pop3::GetMessageHeader(int index)
{
	if(!PutGet(Format("TOP %d %d\r\n", index, 0), true))
		return Null;
	return data;
}

bool Pop3::GetMessageList(ValueMap& list)
{
	VectorMap<int, unsigned int> v;
	
	if(!PutGet("LIST\r\n", true))
		return false;
	return GetListItems(list, INT_V, INT_V);
}


String Pop3::GetMessageUniqueId(int index)
{
	if(!PutGet(Format("UIDL %d\r\n", index)))
		return Null;
	Buffer<char> ok(4), id(64), idx(16);
	sscanf(data, "%s %s %s", &ok[0], &idx[0], &id[0]);
	return String(id);
}

bool Pop3::GetMessageUniqueIds(ValueMap& uids)
{
	if(!PutGet("UIDL\r\n", true))
		return false;
	return GetListItems(uids, INT_V, STRING_V);
}

bool Pop3::RemoveMessage(int index)
{
	return PutGet(Format("DELE %d\r\n", index));
}

bool Pop3::Undo()
{
	return PutGet("RSET\r\n");
}

bool Pop3::Noop()
{
	return PutGet("NOOP\r\n");
}

String Pop3::GetDataLine()
{
	// We can't use TcpSocket::GetLine(), since it omits carriage returns we need.
	String line;
	for(;;) {
		int c = Get();
		if(c < 0) {
			if(!IsError())
				continue;  
			return String::GetVoid();
		}
		line.Cat(c);
		if(line.EndsWith("\r\n"))
			return line;
	}
}

bool Pop3::PutGet(const String& s, bool multiline)
{
	// Put() request.
	if(!s.IsEmpty()) {
		LLOG(">> " << TrimRight(s));
		if(!PutAll(s)) {
			LLOG("-- " << GetLastError());
			return false;
		}		
	}
	// Get() respone.
	data.Clear();
	String line = GetDataLine();
	if(!line.IsEmpty()) {
		LLOG("<< " << TrimRight(line));
		if(line.StartsWith("+OK")) {
			if(!multiline) {
				data << line;
				return true;
			}
			else 
				for(;;) {
					line = GetDataLine();
					if(line.IsEmpty())
						break;
					if(line.StartsWith(".."))
						line.Remove(0);
					data << line;
					if(!data.EndsWith("\r\n.\r\n"))
						continue;
					LLOG("<< ...");
					return true;
				}
		}
		else
		if(line.StartsWith("-ERR"))
			error = line;
	}
	LLOG("-- " << GetLastError());
	return false;
}

bool Pop3::Authenticate()
{
	// Try using APOP authentication.
	String timestamp = GetTimeStamp();
	if(!timestamp.IsEmpty()) {
		if(PutGet("APOP " + user + " " + MD5String(timestamp << pass) + "\r\n"))
			return true;
	}
	else
	if(PutGet("USER " + user + "\r\n"))
		if(PutGet("PASS " + pass + "\r\n"))
			return true;

	return false;
}

bool Pop3::Login()
{
	try {
		if(host.IsEmpty())
			throw Exc(t_("Hostname is not specified."));
		if(user.IsEmpty())
			throw Exc(t_("Username is not specified."));
		if(pass.IsEmpty())
			throw Exc(t_("Password is nor specified."));
		if(!Connect(host, Nvl(port, ssl ? 995 : 110)))
			throw Exc(GetErrorDesc());
		LLOG(Format(t_("Opening connection to %s:%d."), host, port));
		if(ssl) {
			if(!StartSSL())
				throw Exc(t_("Couldn't start SSL session."));
			LLOG(t_("SSL session successfully started."));
		}
		// Receive server greetings.
		if(!PutGet(Null))
			throw Exc(GetLastError());
		if(!Authenticate())
			throw Exc(GetLastError());
	}
	catch (Exc e) {
		error = e;
		LLOG("-- " + e);
		Logout();
		return false;
	}
	return online = true;
}

bool Pop3::Logout()
{
	if(IsOnline()) 
		PutGet("QUIT\r\n");
	LLOG(Format(t_("Closing connection to %s:%d."), host, port));
	Close();
	online = false;
	return true;
}

Pop3::Pop3()
{
	ssl         = false;
	online		= false;
	Timeout(60000);
}

Pop3::~Pop3()
{
	if(IsOpen()) 
		Close();
}



